! Test routine for Atari Pole Position/ Pole II

INCLUDE "Z80.POD"

SETUP
   BEEP ON ERR TRANSITION  YES
   EXERCISE ERRORS         YES
   TRAP ACTIVE FORCE LINE   NO

PROGRAM main

M_LOOP:

DPY-#DISABLING Z8002 PROCESSORS
WRITE @ A004=00
WRITE @ A005=00

DPY-#BUS TEST
BUS

DPY-#RAM TESTS

DPY-#BATTERY BACKED RAM 7E
EX BATRAM

DPY-#MOTION OBJECT MEMORY
EX MOTRAM

DPY-#ROAD MEMORY
EX ROADRAM

DPY-#ALPHANUMERIC MEMORY
EX ALPHARAM

DPY-#SOUND MEMORY 7J 7K
EX SOUNDRAM

DPY-#ATTEMPTING TO RUN BOARD
RUN UUT
DPY-#ALL TESTS COMPLETED
EX DELAY
GOTO M_LOOP


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! delay PROGRAM

PROGRAM delay
REG1 =7FF
0: label 0
DEC REG1
IF REG1 > 0 GOTO 0

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM BATRAM

WRITE @203000 = 0
WRITE @2037FF = 11

WAITLOOP:
   READ @REGF
   IF REGE = B0 GOTO WAITLOOP
   IF REGE = B1 GOTO WAITLOOP
   IF REGE = B2 GOTO WAITLOOP

   IF REGE = F0 GOTO BADRAM
   IF REGE = F1 GOTO BADRAM
   IF REGE = F2 GOTO BADRAM

GOODRAM:
   DPY-#BATTERY BACKED RAM OK
   GOTO RAMEXIT
BADRAM:
   RAM SHORT @3000-37FF
RAMEXIT:
   
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM MOTRAM

WRITE @204400 = 0
WRITE @2047FF = 11

WAITLOOP:
   READ @REGF
   IF REGE = B0 GOTO WAITLOOP
   IF REGE = B1 GOTO WAITLOOP
   IF REGE = B2 GOTO WAITLOOP

   IF REGE = F0 GOTO BADRAM
   IF REGE = F1 GOTO BADRAM
   IF REGE = F2 GOTO BADRAM

GOODRAM:
   DPY-#MOTION OBJECT RAM OK
   GOTO RAMEXIT
BADRAM:
   RAM SHORT @4400-47FF
RAMEXIT:
   
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM ROADRAM

WRITE @204800 = 0
WRITE @2048FF = 11

WAITLOOP:
   READ @REGF
   IF REGE = B0 GOTO WAITLOOP
   IF REGE = B1 GOTO WAITLOOP
   IF REGE = B2 GOTO WAITLOOP

   IF REGE = F0 GOTO BADRAM
   IF REGE = F1 GOTO BADRAM
   IF REGE = F2 GOTO BADRAM

GOODRAM:
   DPY-#ROAD RAM OK
   GOTO RAMEXIT
BADRAM:
   RAM SHORT @4800-48FF
RAMEXIT:
   
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM ALPHARAM

WRITE @204C00 = 0
WRITE @2057FF = 11

WAITLOOP:
   READ @REGF
   IF REGE = B0 GOTO WAITLOOP
   IF REGE = B1 GOTO WAITLOOP
   IF REGE = B2 GOTO WAITLOOP

   IF REGE = F0 GOTO BADRAM
   IF REGE = F1 GOTO BADRAM
   IF REGE = F2 GOTO BADRAM

GOODRAM:
   DPY-#ALPHA RAM OK
   GOTO RAMEXIT

BADRAM:
   RAM SHORT @4C00-57FF
RAMEXIT:
   
     
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
PROGRAM SOUNDRAM

WRITE @208000 = 0
WRITE @2083BF = 11

WAITLOOP:
   READ @REGF
   IF REGE = B0 GOTO WAITLOOP
   IF REGE = B1 GOTO WAITLOOP
   IF REGE = B2 GOTO WAITLOOP

   IF REGE = F0 GOTO BADRAM
   IF REGE = F1 GOTO BADRAM
   IF REGE = F2 GOTO BADRAM

GOODRAM:
   DPY-#SOUND RAM OK
   GOTO RAMEXIT
BADRAM:
   RAM SHORT @8000-83BF
RAMEXIT:
   
     
